let canvas = document.getElementById("can");
let ctx = canvas.getContext("2d");

let requestID; //Variable qui recupère l'ID de l'animation

let y;
let heightMax = 70; // Hauteur de la cuve en cm
let h;

let typeOrifice = 'C';
let tailleOrifice = 2.2; // Taille de l'orifice en cm
let surfaceOrifice = ((tailleOrifice / 2) ** 2) * Math.PI; // Surface de l'orifice en cm²
let finished = true;
let isPaused = false;

let cw = canvas.width;
let ch = canvas.height;




let a;
let b;
let Qe; // Debit entrant en cm³
let g = 9.81; //Pesanteur
let S = 1; // Section de la cuve en cm²
let mu = 0.6;
let n;

let list; // Liste retournée par la méthode euler
let cpt = 0; // Compteur utilisé pour iterer sur la liste retournée par la méthode euler
let temps;  // Temps  necessaire pour que la pompe remplisse la cuve
let speed = 15; // Multiplicateur de vitesse : Variable non utilisée

let dateDebut; // Temps,u début de l'animation
let dateFin; // Temps de fin de l'animation, utilisé pour calculer la durée de l'animation

let vitesse; //Vitesse du jet en sortie de l'orifice

let listJet = []; //Liste de valeurs qui constituent les courbes du jet
let duplicator = 0;


getParameters();

drawBorders();





/* Gère l'animation */
function animate() {
  if (!isPaused) { //Pause l'animation
    requestID = requestAnimationFrame(animate);
  }

  //Vide le canvas et le remplit avec la hauteur souhaité
  ctx.clearRect(1, 0, 4 * cw / 10 - 2, ch - 1);
  ctx.fillRect(1, y - 1, 4 * cw / 10 - 2, ch - y);

  if (y > ch - (heightMax * 4 + 60) && cpt < n) { //Si la hauteur souhaitée n'est pas encore atteinte
    y -= (list[cpt + 1] - list[cpt]) * 4;
    cpt++;

    // Les prochaines lignes servent à dessiner le jet
    h = (canvas.height - y) / (4 * 100);
    if (0.15 - (tailleOrifice / 2 / 100) < h && h < 0.15 + 2 * (tailleOrifice / 2 / 100)) {
      // Ajoute a la liste les valeurs de y pour lesquelles on va dessiner un jet
      listJet.push(y);

      //Sert a ajouter des valeurs entre les valeurs déjà éxistante pour avoir un jet plus réaliste
      if (duplicator < 12) {
        if (listJet.length >= 2) {
          let numAdded = 0;
          let len = listJet.length;
          while (numAdded < len - 1) {
            let valInf = listJet[numAdded];
            let valSup = listJet[numAdded + 1];
            let valRandom = Math.random() * (valSup - valInf) + valSup;
            listJet.splice(numAdded + 1, 0, valRandom);
            numAdded++;
          }
          duplicator++;
          listJet.sort();
        }
      }
    }
    //Appel à la fonction qui dessine le jet
    dessinerJet(y);


  } else { //Fin de l'animation
    cancelAnimationFrame(requestID);
    finished = true;

    dateFin = new Date();

    //console.log('Temps écoulé réellement= ' + (dateFin - dateDebut) / 1000 + ' s');

    //console.log('hauteur demandée = ' + heightMax);
    getParameters();
    document.getElementById("status").innerHTML = "Animation terminée";
    console.log("Finished");
  }
}


/* Fonction qui gère le bouton start */
function start() {
  if (finished) {
    dateDebut = new Date();
    finished = false;
    y = canvas.height;
    cpt = 0;
    duplicator = 0;
    listJet = [];
    ctx.fillStyle = "blue";
    ctx.clearRect(0, 0, cw-1, ch-1);
    getParameters();
    drawBorders();
    temps = temps_necessaire();
    //n = Math.floor((temps / (speed * 10) * 60) + 2);
    n = Math.floor(heightMax * 400 / 70) + 300;
    //console.log("n= " + n);
    list = euler(temps, n);
    //console.log('list: ' + list + '\n temps: ' + temps);
    animate();


    /*
    Cette partie du code sert a faire afficher la courbe de remplissage de la cuve

    let t = [];
    for (let i = 0; i <= n; i++) {
      t.push(i * temps / n)
    }
    var data = [{
      x: t,
      y: list,
      type: 'scatter'
    }];
    var layout = {
      title: 'Remplissage',
      xaxis: {
        title: 'temps'
      },
      yaxis: {
        title: 'hauteur',
      }
    };
    Plotly.newPlot('graph', data, layout);
    */
  }
}


/* Fonction qui gère le bouton pause/restart */
function pause() {
  isPaused = !isPaused;
  animate();
}


/* Fonction qui gère le bouton stop */
function stopA() {
  ctx.clearRect(0, 0, cw-1, ch-1);
  getParameters();
  drawBorders();
  cancelAnimationFrame(requestID);
  finished = true;
}


/* Fonction qui dessine les bordures */
function drawBorders() {
  ctx.clearRect(0, 0, cw-1, ch-1);
  ctx.beginPath();
  ctx.strokeStyle = "black";
  ctx.moveTo(0, 0);
  ctx.lineTo(0, ch);
  ctx.lineTo(4 * cw / 10, ch);
  ctx.lineTo(4 * cw / 10, ch - 60 + tailleOrifice * 4 / 2);
  ctx.moveTo(4 * cw / 10, ch - 60 - tailleOrifice * 4);
  ctx.lineTo(4 * cw / 10, 0);
  ctx.moveTo(4 * cw / 10, ch);
  ctx.lineTo(cw, ch);
  ctx.lineTo(cw, 0);
  ctx.stroke();
}


/* Fait varier la hauteur souhaitée */
function changeHeight(newHeight) {
  if (finished) {
    heightMax = parseFloat(newHeight);
    document.getElementById("heightOutput").value = newHeight;
  }
}

/* Fait varier le multiplicateur de vitesse de l'animation: Non utilisée */
function changeSpeed(newSpeed) {
  if (finished) {
    speed = parseInt(newSpeed);
    document.getElementById("speedOutput").value = 'x' + newSpeed;
  }
}

/* Récupère les paramétres choisis par l'utilsateur  */
function getParameters() {
  const rbs = document.querySelectorAll('input[name="choice"]');
  let selectedValue;
  for (const rb of rbs) {
    if (rb.checked) {
      selectedValue = rb.value;

      typeOrifice = selectedValue[0];
      if (typeOrifice == 'C') {
        tailleOrifice = parseFloat(selectedValue.substring(1)) / 10;
        surfaceOrifice = ((tailleOrifice / 2) ** 2) * Math.PI;
        mu = 0.586;
        document.getElementById("typeOrifice").innerHTML = "Circulaire";
      }
      else if (typeOrifice == 'A') {
        tailleOrifice = parseFloat(selectedValue.substring(1)) / 10;
        surfaceOrifice = (tailleOrifice) ** 2;
        mu = 0.601;
        document.getElementById("typeOrifice").innerHTML = "Carré";
      }
      else {
        surfaceOrifice = parseInt(selectedValue.substring(1)) / 100;
        if (surfaceOrifice == 675) {
          tailleOrifice = 1.5;
        }
        else if (surfaceOrifice == 1365) {
          tailleOrifice = 2.1;
        }
        else {
          tailleOrifice = 3.0;
        }
        mu = 0.592;
        document.getElementById("typeOrifice").innerHTML = "Rectangulaire";
      }
      break;
    }
  }
  document.getElementById("mu").innerHTML = mu;
  document.getElementById("surfaceOrifice").innerHTML = surfaceOrifice.toString().slice(0, 5);
}

/* Calcule le temps necessaire pour que la pompe remplisse la cuve */
function temps_necessaire() {
  let he = heightMax / 100 + 0.65;

  b = mu * (surfaceOrifice / 10000) * Math.sqrt(2 * g) / S;
  a = b * Math.sqrt(he);
  Qe = a * S;
  //console.log('surfaceOrifice = ' + surfaceOrifice / 10000 + ' m²');
  //console.log('b = ' + b);
  //console.log('hauteur theorique = ' + (a ** 2 / b ** 2));
  return -2 / b * ((Math.sqrt(0.99 * he)) + a / b * Math.log((a - b * Math.sqrt(0.99 * he)) / a));
}


/* Resoud une equation differentielle definie par dh/dt = f(h) grace à la méthode d'euler.
Retourne une liste de n+1 éléments avec toutes les valeurs de h entre t0 et tn */
function euler(tn, n) {
  let list = [];
  let dt = tn / n;
  h = 0
  for (let i = 0; i <= n; i++) {
    list.push(h);
    h = h + dt * (a - b * Math.sqrt(h));
  }



  let found = false;
  for (let i = 0; i < list.length; i++) {
    //Multiplie les valeurs par 100 pour les rendre en cm. En effet la résolution de l'équation etait en metre
    list[i] = list[i] * 100;

    //Cherche la première valeur supérieur à 50 et initialise cpt à l'indice de cette valeur. 
    //Cela sert a commencer le remplissage de la cuve à cette valeur. Et cela car la pompe est situé à 50 cm en dessous de la cuve.
    if ((!found) && list[i] > 50) {
      cpt = i;
      found = true;
    }

  }
  return list;
}

/*Dessine le jet grace à la vitesse*/
function dessinerJet(y) {
  ctx.clearRect(4 * cw / 10 + 1, 0, cw-1, ch-1);
  let division = 200;
  let deltaY = tailleOrifice * 4 / division * 3 / 2;
  for (let k = 0; k < listJet.length; k++) {
    h = (canvas.height - y) / (4 * 100);
    //for (let i = 0; i < division; i++) {
    vitesse = 0.98 * Math.sqrt(2 * g * h);
    let alpha = g / (2 * (vitesse ** 2));
    let xFin = Math.sqrt(0.15 / alpha);
    ctx.beginPath();
    let z = ch - 60 + tailleOrifice / 2 * 4 - (ch - listJet[k] - 60 + tailleOrifice / 2 * 4);
    ctx.moveTo(4 * cw / 10 - 1, z);
    //console.log(xFin*4*100);
    ctx.quadraticCurveTo(xFin / 2 * 4 * 100 + 4 * cw / 10, z, xFin * 4 * 100 + 4 * cw / 10, ch);
    ctx.strokeStyle = 'blue';
    ctx.stroke();
    //}
  }
}










/*Fait attendre le programme pendant une duree en ms: Non utilisée */
function wait(ms) {
  let d = new Date();
  let d2 = null;
  do { d2 = new Date(); }
  while (d2 - d < ms);
}